<?php

namespace Noptin\Addons_Pack\Custom_Fields\Actions;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Removes a subscriber from a custom field.
 *
 * @since 2.0.0
 */
class Remove_From_Field extends Add_To_Field {

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return 'remove_from_' . $this->merge_tag;
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Subscriber > Remove from %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Removes the subscriber from %s', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
	 * @inheritdoc
	 */
	public function run( $subject, $rule, $args ) {

		$subscriber = $this->get_subscriber( $subject, $rule, $args );

		if ( ! $subscriber->exists() ) {
			return;
		}

		// Fetch the custom field.
		$value    = noptin_parse_list( $rule->action_settings[ $this->merge_tag ], true );
		$existing = noptin_parse_list( $subscriber->get( $this->merge_tag, array() ), true );

		// Diff the values.
		$subscriber->set( $this->merge_tag, array_unique( array_diff( $existing, $value ) ) );
		$subscriber->save();
	}

}
