<?php

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

// Load each module independently.
$GLOBALS['noptin-addons-pack-modules'] = array(

	// Send new post notifications for custom post types and taxonomies.
	'cpt'                => array(
		'is_active' => ! defined( 'NOPTIN_CPT_FILE' ),
		'file'      => plugin_dir_path( __FILE__ ) . 'cpts/loader.php',
	),

	// Allow customers to manage their subscription preferences.
	'manage-preferences' => array(
		'is_active' => ! defined( 'NOPTIN_MANAGE_PREFERENCES_FILE' ),
		'cb'        => '\Noptin\Addons_Pack\Preferences\Main::instance',
	),

	// Make it possible to mass email WooCommerce customers.
	'wc-customers'       => array(
		'is_active' => ! defined( 'NOPTIN_WC_CUSTOMERS_FILE' ) && function_exists( 'WC' ),
		'cb'        => '\Noptin\Addons_Pack\WooCommerce\Main::instance',
	),

	// Sync subscribers between various sites.
	'sync'               => array(
		'is_active' => ! defined( 'NOPTIN_SYNC_FILE' ),
		'file'      => plugin_dir_path( __FILE__ ) . 'sync/loader.php',
	),

	// Embed opt-in forms on external sites.
	'iframe'             => array(
		'is_active' => ! defined( 'NOPTIN_IFRAME_FILE' ),
		'file'      => plugin_dir_path( __FILE__ ) . 'iframe/loader.php',
	),

	// Send new subscribers a coupon code.
	'coupon-codes'       => array(
		'is_active' => ! defined( 'NOPTIN_COUPON_CODES_FILE' ),
		'cb'        => '\Noptin\Addons_Pack\Coupon_Codes\Main::instance',
	),

	// Popup forms functionality.
	'popups'             => array(
		'is_active' => ! defined( 'NOPTIN_POPUPS_FILE' ),
		'file'      => plugin_dir_path( __FILE__ ) . 'forms/loader.php',
	),

	// Webhooks.
	'webhooks'           => array(
		'is_active' => ! defined( 'NOPTIN_WEBHOOKS_FILE' ),
		'cb'        => '\Noptin\Addons_Pack\Webhooks\Main::instance',
	),

	// Automated emails.
	'emails'             => array(
		'is_active' => true,
		'cb'        => '\Noptin\Addons_Pack\Emails\Main::instance',
	),

	// Tasks runner.
	'tasks'              => array(
		'is_active' => true,
		'cb'        => '\Noptin\Addons_Pack\Tasks\Main::instance',
	),

	// Rule scheduler.
	'schedule_rules'     => array(
		'is_active' => true,
		'cb'        => '\Noptin\Addons_Pack\Schedule_Rules\Main::instance',
	),

	// Custom fields.
	'custom_fields'      => array(
		'is_active' => true,
		'cb'        => '\Noptin\Addons_Pack\Custom_Fields\Main::instance',
	),

	// WordPress users integration.
	'users'              => array(
		'is_active' => ! defined( 'NOPTIN_WP_USERS_FILE' ),
		'cb'        => '\Noptin\Addons_Pack\Users\Main::instance',
	),
);

foreach ( apply_filters( 'noptin-addons-pack-modules', $GLOBALS['noptin-addons-pack-modules'] ) as $module ) {
	if ( $module['is_active'] ) {

		if ( isset( $module['cb'] ) ) {
			call_user_func( $module['cb'] );
		} else {
			require_once $module['file'];
		}
	}
}

/**
 * Runs the installer, if needed.
 */
$installed_version = get_option( 'noptin_addons_pack_version', false );

if ( NOPTIN_ADDONS_PACK_VERSION !== $installed_version ) {
	update_option( 'noptin_addons_pack_version', NOPTIN_ADDONS_PACK_VERSION );
	update_option( 'noptin_addons_pack_modules', array_keys( $GLOBALS['noptin-addons-pack-modules'] ) );
}
