<?php

namespace Noptin\Addons_Pack\Custom_Fields\Triggers;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Fired when a custom field value changes.
 *
 * @since 2.0.0
 */
class Change_Field extends Abstract_Trigger {

	/**
	 * @inheritdoc
	 */
	public function attach_hooks() {
		add_action( "noptin_subscriber_{$this->merge_tag}_changed", array( $this, 'trigger_changed' ), 10, 3 );
	}

	/**
	 * @inheritdoc
	 */
	public function get_id() {
		return $this->merge_tag . '_changed';
	}

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return sprintf(
			/* translators: %s: field label */
			__( 'Subscriber > %s changed', 'noptin-addons-pack' ),
			$this->label
		);
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return sprintf(
			/* translators: %s: field label */
			__( 'When %s changes', 'noptin-addons-pack' ),
			strtolower( $this->label )
		);
	}

	/**
     * Returns an array of known smart tags.
     *
     * @since 2.0.0
     * @return array
     */
    public function get_known_smart_tags() {

		return array_replace(
			array(
				'old_value' => array(
					'description'       => __( 'The old value', 'noptin-addons-pack' ),
					'example'           => 'old_value',
					'conditional_logic' => 'string',
					'options'           => $this->get_options(),
				),
				'new_value' => array(
					'description'       => __( 'The new value', 'noptin-addons-pack' ),
					'example'           => 'new_value',
					'conditional_logic' => 'string',
					'options'           => $this->get_options(),
				),
			),
			parent::get_known_smart_tags()
		);
	}

	/**
	 * Prepares email test data.
	 *
	 * @since 2.0.0
	 * @param Noptin_Automation_Rule $rule
	 * @return Noptin_Automation_Rules_Smart_Tags
	 * @throws Exception
	 */
	public function get_test_smart_tags( $rule ) {

		$subject = noptin_get_subscriber( get_current_noptin_subscriber_id() );
		$args    = $this->prepare_trigger_args(
			$subject,
			array(
				'old_value' => 'Old Value',
				'new_value' => 'New Value',
			)
		);

		return $args['smart_tags'];
	}

}
